﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent
{
    public partial class DemoAI5620 : Advent.Controls.DeviceCtrl
    {

        private AI5620_TE_Simulator _5620 = null;

        public DemoAI5620()
        {
            InitializeComponent();
            txt_ConnectSerial.Text = "SN140001";
        }
        protected override aiDevice GetDeviceReference()
        {
            return _5620;
        }

        /// <summary>
        /// Called to initialize communications with the device
        /// </summary>
        protected override void Connect(string Serial)
        {
            if (Serial == null)
            {
                _5620 = AI5620_TE_Simulator.Connect();



            }
            else
            {
                _5620 = AI5620_TE_Simulator.Connect(Serial);
            }
        }

        protected override void InitializeFormFromDevice()
        {
            base.InitializeFormFromDevice();
            
            // We assign each of the controls the relavent support object reference
            FSKGenCtrl.SetGenerator(_5620.FSKGenerator);
            ToneACtrl.SetGenerator(_5620.ToneA);
            ToneBCtrl.SetGenerator(_5620.ToneB);
            ToneCCtrl.SetGenerator(_5620.ToneC);
            ToneDCtrl.SetGenerator(_5620.ToneD);
            AMCtrl.SetGenerator(_5620.AMGenerator);
            EchoCtrl.SetGenerator(_5620.EchoGenerator);
            DetectedCtrl.SetList(_5620.DetectedSignals);
            TelIntCtrl.SetTelInt(_5620.TelInt,_5620.Capabilities);
            DigitalIO.SetDigitalIO(_5620.DigitalIO);
            MeterCtrl.SetMeter(_5620.Meter);
            PatternCtrl.SetGenerator(_5620.PatternGenerator);
            MFCtrl.SetGenerator(_5620.MFGenerator);
            StatusCtrl.SetStatus(_5620.Status);
            NoiseCtrl.SetGenerator(_5620.NoiseGenerator);
            PulseDialCtrl.SetGenerator(_5620.PulseDialingGenerator);
            TermLevels.SetSupportObjects(_5620.ToneA, _5620.Meter, _5620.TelInt);






        }

        private void btn_ResetProtection_Click(object sender, EventArgs e)
        {
            try
            {
                if (_5620 == null) return;
                _5620.Protection.Reset();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }




    }
}
